/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import java.io.IOException;
import java.util.List;

public class ShiftRegisterParameter
extends BlockParameter {
    static final long serialVersionUID = 5275992679348271799L;
    private int blockSerializedDataVersion = 1;
    private int fOutputBit;
    private int fIndex = -1;
    private transient boolean fTrgInputLastCycle;

    public ShiftRegisterParameter() {
    }

    public ShiftRegisterParameter(Block block) {
        super(block);
        this.setRemanenceAvailable(true);
    }

    protected boolean calculateValue(boolean in, boolean trg, boolean dir) {
        byte shiftRegister = this.fInterpreter.getShiftRegisterValue()[this.fIndex];
        if (!this.fTrgInputLastCycle && trg) {
            this.fTrgInputLastCycle = true;
            if (dir) {
                shiftRegister = (byte)(shiftRegister >> 1);
                shiftRegister = in ? (byte)(shiftRegister | 0x80) : (byte)(shiftRegister & 0xFFFFFF7F);
            } else {
                shiftRegister = (byte)(shiftRegister << 1);
                shiftRegister = in ? (byte)(shiftRegister | 1) : (byte)(shiftRegister & 0xFFFFFFFE);
            }
            this.fInterpreter.setShiftRegisterValue(shiftRegister, this.fIndex);
        } else if (this.fTrgInputLastCycle && !trg) {
            this.fTrgInputLastCycle = false;
        }
        return (shiftRegister & 1 << this.fOutputBit) != 0;
    }

    public boolean getValue(boolean in, boolean trg, boolean dir) {
        boolean rw = this.calculateValue(in, trg, dir);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return rw;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fOutputBit = dr.readInt();
        this.fIndex = dr.readInt();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fOutputBit);
        dw.writeInt(this.fIndex);
    }

    public Integer getOutputBit() {
        return this.fOutputBit;
    }

    public void setOutputBit(Integer outputBit) {
        this.fOutputBit = outputBit;
    }

    public Integer getIndex() {
        return this.fIndex;
    }

    public void setIndex(int index, boolean setOldIndexToFree) {
        if (this.fIndex == index) {
            return;
        }
        int[] resourceArr = this.getBlock().getWiringDiagram().getNumberResource(18);
        if (setOldIndexToFree && this.fIndex >= 0) {
            resourceArr[this.fIndex] = 0;
        }
        this.fIndex = index;
        if (this.fIndex >= 0) {
            resourceArr[this.fIndex] = 2;
        }
        this.fireParameterSetEvent();
    }

    public void setIndex(Integer index) {
        this.setIndex(index, true);
    }

    public String getParameterText() {
        String text = super.getParameterText();
        return "Q=S" + (this.fIndex + 1) + "." + (this.getOutputBit() + 1) + "\n" + text;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.fTrgInputLastCycle = false;
            interpreter.setShiftRegisterValue((byte)0, this.fIndex);
        }
    }

    public boolean isAvailable(Hardware hardware, List errorList) {
        boolean result = super.isAvailable(hardware, errorList);
        if (this.fIndex > 0 && hardware.getMaxResource(18) == 1) {
            errorList.add(new ErrorInfo(this, "error.convert.shiftRegister.indexOutOfRange", hardware));
            result = false;
        }
        return result;
    }
}

